#!/usr/bin/perl
# ------------------------------------------------------------------------------
# -- Copyright (c) 2024 Jersey Jack Pinball ------------------------------------
# ------------------------------------------------------------------------------
use utf8;
use strict;
use warnings;

# ------------------------------------------------------------------------------
# -- globals -------------------------------------------------------------------
# ------------------------------------------------------------------------------
my @displays = ();
my $primary_display = undef;
my $secondary_display = undef;
my $tertiary_display = undef;
my @primary_resolutions = qw(1920x1080 1680x1050 1366x768 1360x768);
my @secondary_resolutions = qw(1920x610 1920x360 1024x768 1024x600 800x480 480x480);
my @tertiary_resolutions = qw(1024x768);
my $primary_resolution = undef;
my $secondary_resolution = undef;
my $tertiary_resolution = undef;
my ($outfile) =  @ARGV;

# ------------------------------------------------------------------------------
# -- functions -----------------------------------------------------------------
# ------------------------------------------------------------------------------
sub parse_xrandr_output {
    $ENV{'DISPLAY'} = ':0';
	my @lines = `xrandr`;
    my $cur_resolutions = undef;
    foreach (@lines) {
        chomp;
        if (/Screen/) {
            next;
        } if (/disconnected/) {
            next;
        } if (/connected/) {
            my $cur_display = substr($_, 0, index($_, ' '));
            if (defined $cur_resolutions) {
                push @displays, $cur_resolutions;
            }
 
            my @a = ();
            $cur_resolutions = \@a;
            push @$cur_resolutions, $cur_display;
        } else {
            my $line = substr($_, 3);
            my $resolution = substr($line, 0, index($line, ' '));
			if (/\+/) {
                $resolution = $resolution.'+';
            }

            if (/\*/) {
                $resolution = $resolution.'*';
            }

            push @$cur_resolutions, $resolution;
        }
    }

    if (defined $cur_resolutions) {
        push @displays, $cur_resolutions;
    }
}

# ------------------------------------------------------------------------------
sub set_display {
	my ($display, $resolutions, $resolution) = @_;
	foreach my $pr (@$resolutions) {
		foreach my $d (@displays) {
			foreach (@$d) {
				if (/\+/ and /\*/ and /$pr/) {
					s/\+\*//;
					$$resolution = $_;
					$$display = @$d[0];
					last;
				}
			}
        }
    }
}

# ------------------------------------------------------------------------------
sub write_display_file {
    open DISP, '>', "$outfile";
    print DISP "sleep 1\n";
	if ($primary_display) {
		print DISP "# main display\n";
		print DISP "xrandr "
			."--output $primary_display --pos 0x0 --mode $primary_resolution\n";
	}

	if ($secondary_display) {
		print DISP "# aux1 display\n";
		if ($secondary_resolution eq '1024x600') {
			print DISP "xrandr "
				."--output $secondary_display --mode $secondary_resolution "
				."--right-of $primary_display --set 'max bpc' 8\n";
		} else {
			print DISP "xrandr "
				."--output $secondary_display --mode $secondary_resolution "
				."--right-of $primary_display \n";
		}
	}

	if ($tertiary_display) {
		print DISP "# aux2 display\n";
		if ($tertiary_display eq '1024x600') {
			print DISP "xrandr "
				."--output $tertiary_display --mode $tertiary_resolution "
				."--right-of $secondary_display --set 'max bpc' 8\n";
		} else {
			print DISP "xrandr "
				."--output $tertiary_display --mode $tertiary_resolution "
				."--right-of $secondary_display\n";
		}
	}

    print DISP "sleep 1\n";
    close DISP;
}

# ------------------------------------------------------------------------------
# -- main ----------------------------------------------------------------------
# ------------------------------------------------------------------------------
if (not defined $outfile) {
	printf "missing arg: outfile\n";
	exit;
}
parse_xrandr_output();
set_display(\$primary_display, \@primary_resolutions, \$primary_resolution);
set_display(\$secondary_display, \@secondary_resolutions,
	\$secondary_resolution);
set_display(\$tertiary_display, \@tertiary_resolutions, \$tertiary_resolution);
write_display_file();
system "chmod --silent +x $outfile";
