#!/bin/sh
# Create the hardware info file for game diag utility
HWINFO_FILE=/tmp/hwinfo
# inxi complains if $HOME isn't set, so set it
export HOME=/root
# -M machine data (MB, etc.)
# -C CPU output
# -m memory
# -D hard disk
# -s sensors
# -i WAN IP
# -Z override network filter
# -E bluetooth
# -c 0 turn off color scheme
inxi -M -C -m -D -s -i -Z -c 0 | sed '/Array-/d ; /No Module/d ; /Fan Speed/d ; s/  */  /' > $HWINFO_FILE
xrandr | sed -n '/HDMI\|VGA\|DP/p' >> $HWINFO_FILE
# list the JJP USB devices
lsusb -d 0001: >> $HWINFO_FILE
lsusb -d 07FF: >> $HWINFO_FILE
# list external 10-port hub (it contains two hub chips)
lsusb -d 05e3: >> $HWINFO_FILE
lsusb -d 0424:2517 >> $HWINFO_FILE