#!/bin/bash
#
# Script for creating hstd WEBMs from separate PNGs.
#
################################################################################

#################################################################################
#################################################################################
# main
#################################################################################
#################################################################################
# $1	infiles - should be wildcarded, so all the relevant png files get munged into the webm
# $2	outfile - should be a .webm file name
#################################################################################
# now issue the ffmpeg command
#################################################################################

#set -x
ffmpeg -hide_banner -v quiet -i "$1" -c:v libvpx-vp9 -b:v 0 -crf 34 -auto-alt-ref 0 -pix_fmt yuva420p -r 24 -g 9999 -an -y "$2"
pngdir=$(printf '%s' "$1" | grep -o '/.*/')
rm $pngdir/*.png
#set +x
exit 0
